# This perl script checks for modules we need
# and writes the Makefile for Zigzag
#
# Last updated by gossamer on Sun Jul 12 04:51:11 EST 1998
#
require 5;
use strict;

# Check for modules we need.
$| = 1;
my $missing_modules = 0;

print "Checking for Curses ...";
eval {
    require Curses;
};
if ($@) {
    print " missing!\n";
    $missing_modules++;
    print "$@\n";
    sleep(2);  # Don't hurry too much
} else {
    print " got it\n";
}

print "Checking for Data::Dumper (only required for zzdump/zzundump) ...";
eval {
    require Curses;
};
if ($@) {
    print " missing!\n";
    $missing_modules++;
    print "$@\n";
    sleep(2);  # Don't hurry too much
} else {
    print " got it\n";
}

print <<EOT if $missing_modules;
The missing modules can be obtained from CPAN - you'll need them to
complete the installation.  

Visit <URL:http://www.perl.com/CPAN/> to find a CPAN site near you.

EOT

use ExtUtils::MakeMaker;
WriteMakefile(
    'NAME'	   => 'zigzag',
    'EXE_FILES'    => [ 'zigzag', 'Programs/zzdump', 'Programs/zzundump' ],
    'VERSION_FROM' => 'zigzag',
    'dist'         => { 
                         COMPRESS => 'gzip -9f',
                         SUFFIX => 'gz',
                      },
);

